<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%appointments}}`.
 */
class m260217_150422_create_appointments_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('appointments', [
            'id' => $this->primaryKey(),
            'master_info_id' => $this->integer()->notNull(),
            'service_id' => $this->integer()->notNull(),
            'client_id' => $this->integer()->notNull(),
            'start_time' => $this->datetime()->notNull(),
            'end_time' => $this->datetime()->notNull(),
            'payment_method' => $this->string(50)->notNull(),
            'additional_info' => $this->text(),
            'status' => $this->tinyInteger()->defaultValue(0)->comment('0 - новая, 1 - подтверждена, 2 - отменена'),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);

        // Индексы
        $this->createIndex('idx-appointments-master', 'appointments', 'master_info_id');
        $this->createIndex('idx-appointments-service', 'appointments', 'service_id');
        $this->createIndex('idx-appointments-client', 'appointments', 'client_id');
        $this->createIndex('idx-appointments-start', 'appointments', 'start_time');

        // Внешние ключи
        $this->addForeignKey(
            'fk-appointments-master_info_id',
            'appointments',
            'master_info_id',
            'master_info',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-appointments-service_id',
            'appointments',
            'service_id',
            'services',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-appointments-client_id',
            'appointments',
            'client_id',
            'users',
            'id',
            'CASCADE'
        );
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-appointments-master_info_id', 'appointments');
        $this->dropForeignKey('fk-appointments-service_id', 'appointments');
        $this->dropForeignKey('fk-appointments-client_id', 'appointments');
        $this->dropTable('appointments');
    }
}
