<?php

namespace app\models;

use Yii;
use yii\web\UploadedFile;

class MasterPortfolio extends \yii\db\ActiveRecord
{
    public $imageFile; // для загрузки файла

    public static function tableName()
    {
        return 'master_portfolio';
    }

    public function rules()
    {
        return [
            [['master_info_id', 'photo_url'], 'required'],
            [['master_info_id'], 'integer'],
            [['description'], 'string'],
            [['created_at'], 'safe'],
            [['photo_url'], 'string', 'max' => 500],
            [['master_info_id'], 'exist', 'skipOnError' => true, 'targetClass' => MasterInfo::class, 'targetAttribute' => ['master_info_id' => 'id']],
            [['imageFile'], 'file',
                'skipOnEmpty' => true,
                'extensions' => 'png, jpg, jpeg, webp',
                'maxSize' => 5 * 1024 * 1024, // 5 MB
                'tooBig' => 'Файл слишком большой. Максимальный размер 5 МБ',
                'wrongExtension' => 'Разрешены только файлы с расширениями: png, jpg, jpeg, webp'
            ],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'master_info_id' => 'Master Info ID',
            'photo_url' => 'Фото',
            'description' => 'Описание',
            'created_at' => 'Дата добавления',
            'imageFile' => 'Фото работы',
        ];
    }

    public function getMasterInfo()
    {
        return $this->hasOne(MasterInfo::class, ['id' => 'master_info_id']);
    }
}