<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "master_services".
 *
 * @property int $id
 * @property int $master_info_id
 * @property int $service_id
 * @property float|null $price_modifier наценка/скидка от базовой цены
 *
 * @property MasterInfo $masterInfo
 * @property Service $service
 */
class MasterService extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'master_services';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['price_modifier'], 'default', 'value' => 0.00],
            [['master_info_id', 'service_id'], 'required'],
            [['master_info_id', 'service_id'], 'integer'],
            [['price_modifier'], 'number'],
            [['master_info_id', 'service_id'], 'unique', 'targetAttribute' => ['master_info_id', 'service_id']],
            [['master_info_id'], 'exist', 'skipOnError' => true, 'targetClass' => MasterInfo::class, 'targetAttribute' => ['master_info_id' => 'id']],
            [['service_id'], 'exist', 'skipOnError' => true, 'targetClass' => Service::class, 'targetAttribute' => ['service_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'master_info_id' => 'Master Info ID',
            'service_id' => 'Service ID',
            'price_modifier' => 'Price Modifier',
        ];
    }

    /**
     * Gets query for [[MasterInfo]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMasterInfo()
    {
        return $this->hasOne(MasterInfo::class, ['id' => 'master_info_id']);
    }

    /**
     * Gets query for [[Service]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getService()
    {
        return $this->hasOne(Service::class, ['id' => 'service_id']);
    }

}
