<?php

namespace app\models;

use Yii;

class Service extends \yii\db\ActiveRecord
{
    public static function tableName()
    {
        return 'services';
    }

    public function rules()
    {
        return [
            [['master_id', 'name', 'duration', 'price'], 'required'],
            [['master_id', 'duration'], 'integer'],
            [['description'], 'string'],
            [['price'], 'number'],
            [['name'], 'string', 'max' => 255],
            [['master_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['master_id' => 'id']],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'master_id' => 'Мастер',
            'name' => 'Название',
            'description' => 'Описание',
            'duration' => 'Длительность (мин)',
            'price' => 'Цена',
        ];
    }

    public function getMaster()
    {
        return $this->hasOne(User::class, ['id' => 'master_id']);
    }

    public function getMasterServices()
    {
        return $this->hasMany(MasterService::class, ['service_id' => 'id']);
    }

    public function getMasterInfos()
    {
        return $this->hasMany(MasterInfo::class, ['id' => 'master_info_id'])
            ->viaTable('master_services', ['service_id' => 'id']);
    }

    public function getCategory()
    {
        return $this->hasOne(ServiceCategory::class, ['id' => 'category_id']);
    }

    public function getMasters()
    {
        return User::find()
            ->alias('u')
            ->innerJoin('master_info mi', 'mi.user_id = u.id')
            ->innerJoin('master_services ms', 'ms.master_info_id = mi.id')
            ->where(['ms.service_id' => $this->id])
            ->andWhere(['u.is_admin' => 1])
            ->all();
    }

// Проверить, есть ли у услуги мастера
    public function hasMasters()
    {
        return MasterService::find()
            ->where(['service_id' => $this->id])
            ->exists();
    }
}