<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "service_categories".
 *
 * @property int $id
 * @property string $name
 * @property string|null $description
 * @property int|null $sort
 *
 * @property Service[] $services
 */
class ServiceCategory extends \yii\db\ActiveRecord
{
    public static function tableName()
    {
        return 'service_categories';
    }

    public function rules()
    {
        return [
            [['name'], 'required'],
            [['description'], 'string'],
            [['sort'], 'integer'],
            [['name'], 'string', 'max' => 255],
        ];
    }

    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Название категории',
            'description' => 'Описание',
            'sort' => 'Сортировка',
        ];
    }

    public function getServices()
    {
        return $this->hasMany(Service::class, ['category_id' => 'id']);
    }
}