<?php

use app\models\Appointment;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/** @var yii\web\View $this */
/** @var app\models\AppointmentSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Заявки';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="appointment-index">

    <h1><?= Html::encode($this->title) ?></h1>


    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            [
                'attribute' => 'client_id',
                'value' => function($model) {
                    return $model->client ? $model->client->surname . ' ' . $model->client->name : 'Не указан';
                },
                'label' => 'Клиент',
            ],
            [
                'attribute' => 'master_info_id',
                'value' => function($model) {
                    if ($model->masterInfo && $model->masterInfo->user) {
                        return $model->masterInfo->user->surname . ' ' . $model->masterInfo->user->name;
                    }
                    return 'Не указан';
                },
                'label' => 'Мастер',
            ],
            [
                'attribute' => 'service_id',
                'value' => function($model) {
                    return $model->service ? $model->service->name : 'Не указана';
                },
                'label' => 'Услуга',
            ],
            'start_time:datetime',
            [
                'attribute' => 'status',
                'value' => function($model) {
                    $statuses = [0 => 'Новая', 1 => 'Подтверждена', 2 => 'Отменена', 3 => 'Завершена'];
                    return $statuses[$model->status] ?? $model->status;
                },
            ],
            'start_time',
            'end_time',
            'payment_method',
            'additional_info:ntext',
            'status',
            'created_at',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Appointment $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
