<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Панель администратора';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="admin-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-3 col-sm-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-user" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= \app\models\User::find()->count() ?></div>
                            <div>Всего пользователей</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Управление пользователями', ['user/index'], ['class' => 'btn btn-primary btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-scissors" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= \app\models\Service::find()->count() ?></div>
                            <div>Услуг</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Управление услугами', ['service/index'], ['class' => 'btn btn-success btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-calendar" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= \app\models\Appointment::find()->count() ?></div>
                            <div>Заявок</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Все заявки', ['appointment/index'], ['class' => 'btn btn-info btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-3 col-sm-6">
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-stats" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;">📊</div>
                            <div>Отчеты</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Сформировать отчеты', ['reports/index'], ['class' => 'btn btn-warning btn-block']) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Быстрые действия</h3>
                </div>
                <div class="panel-body">
                    <?= Html::a('Управление категориями', ['service-category/index'], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('Привязка услуг к мастерам', ['master-service/index'], ['class' => 'btn btn-warning']) ?>
                </div>
            </div>
        </div>
    </div>
</div>