<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Отчет по заявкам';
$this->params['breadcrumbs'][] = ['label' => 'Отчеты', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="reports-appointments">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="panel panel-default">
        <div class="panel-body">
            <?php $form = ActiveForm::begin(['method' => 'get', 'action' => ['appointments']]); ?>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>От</label>
                        <input type="date" name="from_date" class="form-control" value="<?= $fromDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>До</label>
                        <input type="date" name="to_date" class="form-control" value="<?= $toDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary form-control">Применить</button>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <h3 class="panel-title">Статистика по статусам</h3>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-2 col-sm-4">
                            <div class="well text-center">
                                <h4>Всего</h4>
                                <p class="text-primary" style="font-size: 24px;"><?= $statusStats['total'] ?></p>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-4">
                            <div class="well text-center">
                                <h4>Новые</h4>
                                <p class="text-warning" style="font-size: 24px;"><?= $statusStats['new'] ?></p>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-4">
                            <div class="well text-center">
                                <h4>Подтверждены</h4>
                                <p class="text-success" style="font-size: 24px;"><?= $statusStats['confirmed'] ?></p>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-4">
                            <div class="well text-center">
                                <h4>Завершены</h4>
                                <p class="text-info" style="font-size: 24px;"><?= $statusStats['completed'] ?></p>
                            </div>
                        </div>
                        <div class="col-md-2 col-sm-4">
                            <div class="well text-center">
                                <h4>Отменены</h4>
                                <p class="text-danger" style="font-size: 24px;"><?= $statusStats['cancelled'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Заявки по дням (<?= $fromDate ?> - <?= $toDate ?>)</h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped">
                <thead>
                <tr>
                    <th>Дата</th>
                    <th>Всего заявок</th>
                    <th>Завершено</th>
                    <th>% завершения</th>
                </tr>
                </thead>
                <tbody>
                <?php $totalAll = 0; $totalCompleted = 0; ?>
                <?php foreach ($dailyStats as $stat): ?>
                    <?php
                    $totalAll += $stat['count'];
                    $totalCompleted += $stat['completed'];
                    $percent = $stat['count'] > 0 ? round(($stat['completed'] / $stat['count']) * 100) : 0;
                    ?>
                    <tr>
                        <td><?= Yii::$app->formatter->asDate($stat['date'], 'php:d.m.Y') ?></td>
                        <td><?= $stat['count'] ?></td>
                        <td><?= $stat['completed'] ?></td>
                        <td>
                            <div class="progress">
                                <div class="progress-bar progress-bar-success" style="width: <?= $percent ?>%">
                                    <?= $percent ?>%
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
                <tfoot>
                <tr class="info">
                    <th><strong>Итого:</strong></th>
                    <th><?= $totalAll ?></th>
                    <th><?= $totalCompleted ?></th>
                    <th>
                        <?php
                        $totalPercent = $totalAll > 0 ? round(($totalCompleted / $totalAll) * 100) : 0;
                        echo $totalPercent . '%';
                        ?>
                    </th>
                </tr>
                </tfoot>
            </table>

            <?php if (empty($dailyStats)): ?>
                <p class="text-muted">Нет данных за выбранный период</p>
            <?php endif; ?>
        </div>
    </div>

    <div class="text-center">
        <?= Html::a('Назад к отчетам', ['index'], ['class' => 'btn btn-default']) ?>
    </div>
</div>