<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Отчеты';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="reports-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-4">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <h3 class="panel-title">По количеству заявок</h3>
                </div>
                <div class="panel-body">
                    <p>Статистика по количеству заявок за период: новые, подтвержденные, завершенные, отмененные.</p>
                    <?= Html::a('Смотреть отчет', ['appointments'], ['class' => 'btn btn-primary btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <h3 class="panel-title">По выручке</h3>
                </div>
                <div class="panel-body">
                    <p>Финансовый отчет: выручка по дням, по услугам, общая сумма за период.</p>
                    <?= Html::a('Смотреть отчет', ['revenue'], ['class' => 'btn btn-success btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <h3 class="panel-title">По загруженности мастеров</h3>
                </div>
                <div class="panel-body">
                    <p>Количество записей, выполненных работ и выручка по каждому мастеру.</p>
                    <?= Html::a('Смотреть отчет', ['masters-load'], ['class' => 'btn btn-warning btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
</div>