<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Загруженность мастеров';
$this->params['breadcrumbs'][] = ['label' => 'Отчеты', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="reports-masters-load">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="panel panel-default">
        <div class="panel-body">
            <?php $form = ActiveForm::begin(['method' => 'get', 'action' => ['masters-load']]); ?>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label>От</label>
                        <input type="date" name="from_date" class="form-control" value="<?= $fromDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>До</label>
                        <input type="date" name="to_date" class="form-control" value="<?= $toDate ?>">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary form-control">Применить</button>
                    </div>
                </div>
            </div>
            <?php ActiveForm::end(); ?>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Статистика по мастерам за период <?= $fromDate ?> - <?= $toDate ?></h3>
        </div>
        <div class="panel-body">
            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th>Мастер</th>
                    <th>Специализация</th>
                    <th>Всего записей</th>
                    <th>Выполнено</th>
                    <th>Выручка</th>
                    <th>Загруженность</th>
                </tr>
                </thead>
                <tbody>
                <?php
                $totalAppointments = 0;
                $totalCompleted = 0;
                $totalRevenue = 0;
                $maxAppointments = !empty($masterStats) ? max(array_column($masterStats, 'appointments')) : 1;
                ?>

                <?php foreach ($masterStats as $stat): ?>
                    <?php
                    $totalAppointments += $stat['appointments'];
                    $totalCompleted += $stat['completed'];
                    $totalRevenue += $stat['revenue'];
                    $loadPercent = $maxAppointments > 0 ? round(($stat['appointments'] / $maxAppointments) * 100) : 0;
                    ?>
                    <tr>
                        <td>
                            <strong><?= Html::encode($stat['master']->surname . ' ' . $stat['master']->name) ?></strong>
                        </td>
                        <td>
                            <?= $stat['info'] && $stat['info']->specialization ?
                                Html::encode($stat['info']->specialization) :
                                '<span class="text-muted">—</span>' ?>
                        </td>
                        <td class="text-center"><?= $stat['appointments'] ?></td>
                        <td class="text-center"><?= $stat['completed'] ?></td>
                        <td class="text-right"><strong><?= number_format($stat['revenue'], 2, '.', ' ') ?> руб.</strong></td>
                        <td style="width: 200px;">
                            <div class="progress">
                                <div class="progress-bar progress-bar-info" style="width: <?= $loadPercent ?>%">
                                    <?= $loadPercent ?>%
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
                <tfoot>
                <tr class="info">
                    <th colspan="2"><strong>Итого:</strong></th>
                    <th class="text-center"><?= $totalAppointments ?></th>
                    <th class="text-center"><?= $totalCompleted ?></th>
                    <th class="text-right"><?= number_format($totalRevenue, 2, '.', ' ') ?> руб.</th>
                    <th></th>
                </tr>
                </tfoot>
            </table>

            <?php if (empty($masterStats)): ?>
                <p class="text-muted">Нет данных за выбранный период</p>
            <?php endif; ?>
        </div>
    </div>

    <div class="text-center">
        <?= Html::a('Назад к отчетам', ['index'], ['class' => 'btn btn-default']) ?>
    </div>
</div>