<?php

use app\models\Service;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\ServiceSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Услуги';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="service-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Добавить услугу', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            [
                'attribute' => 'master_id',
                'value' => function($model) {
                    if ($model->master) {
                        return $model->master->surname . ' ' . $model->master->name;
                    }
                    return 'Не указан';
                },
                'label' => 'Мастер',
                'filter' => \yii\helpers\ArrayHelper::map(
                    \app\models\User::find()->where(['is_admin' => 1])->all(),
                    'id',
                    function($user) {
                        return $user->surname . ' ' . $user->name;
                    }
                ),
            ],
            'name',
            'description:ntext',
            'duration',
            'price',
           // 'category_id',
            'is_active',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Service $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
