<?php
use yii\helpers\Url;
use yii\helpers\Html;

$this->title = 'Запись к мастеру';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-appointment">
        <div class="appointment-header">
            <h1><?= Html::encode($this->title) ?></h1>
            <div class="divider">
                <span class="divider-icon">📅</span>
            </div>
            <p class="header-description">Выберите удобное время для визита в наш салон</p>
        </div>

        <div class="appointment-container">
            <div class="appointment-card">
                <div class="appointment-card-header">
                    <h3>Форма записи</h3>
                </div>
                <div class="appointment-card-body">

                    <form id="appointment-form">
                        <!-- Шаг 1: Выбор мастера -->
                        <div class="form-group">
                            <label class="beauty-label">👤 Мастер</label>
                            <select id="master-select" class="beauty-select" required>
                                <option value="">-- Выберите мастера --</option>
                                <?php foreach ($masters as $master): ?>
                                    <option value="<?= $master->id ?>">
                                        <?= Html::encode($master->surname . ' ' . $master->name) ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>

                        <!-- Шаг 2: Выбор услуги -->
                        <div class="form-group" id="service-group" style="display: none;">
                            <label class="beauty-label">💇 Выберите услугу</label>
                            <select id="service-select" class="beauty-select" required>
                                <option value="">-- Выберите услугу --</option>
                            </select>
                        </div>

                        <!-- Информация об услуге -->
                        <div id="service-info" class="service-info-card" style="display: none;"></div>

                        <!-- Шаг 3: Выбор даты -->
                        <div class="form-group" id="date-group" style="display: none;">
                            <label class="beauty-label">📆 Дата</label>
                            <input type="date" id="date-input" class="beauty-input" min="<?= date('Y-m-d') ?>" required>
                        </div>

                        <!-- Шаг 4: Выбор времени -->
                        <div class="form-group" id="time-group" style="display: none;">
                            <label class="beauty-label">⏰ Время</label>
                            <select id="time-select" class="beauty-select" required>
                                <option value="">-- Выберите время --</option>
                            </select>
                        </div>

                        <!-- Шаг 5: Способ оплаты -->
                        <div class="form-group" id="payment-group" style="display: none;">
                            <label class="beauty-label">💳 Способ оплаты</label>
                            <select id="payment-select" class="beauty-select" required>
                                <option value="">-- Выберите способ оплаты --</option>
                                <option value="cash">💵 Наличные</option>
                                <option value="card">💳 Карта</option>
                                <option value="online">📱 Онлайн</option>
                            </select>
                        </div>

                        <!-- Шаг 6: Комментарий -->
                        <div class="form-group" id="info-group" style="display: none;">
                            <label class="beauty-label">📝 Комментарий</label>
                            <textarea id="additional-info" class="beauty-textarea" rows="3" placeholder="Ваши пожелания..."></textarea>
                        </div>

                        <!-- Кнопка отправки -->
                        <div class="form-group" id="submit-group" style="display: none;">
                            <button type="submit" class="beauty-submit-btn">✨ Записаться</button>
                        </div>
                    </form>

                    <div id="form-message" class="form-message"></div>

                </div>
            </div>

            <!-- Блок с информацией -->
            <div class="appointment-info">
                <div class="info-card">
                    <div class="info-icon">💡</div>
                    <h4>Как записаться?</h4>
                    <ol>
                        <li>Выберите мастера</li>
                        <li>Выберите услугу</li>
                        <li>Выберите удобную дату</li>
                        <li>Выберите свободное время</li>
                        <li>Укажите способ оплаты</li>
                        <li>Нажмите "Записаться"</li>
                    </ol>
                </div>

                <div class="info-card">
                    <div class="info-icon">⏰</div>
                    <h4>Режим работы</h4>
                    <p>Пн-Пт: 9:00 - 21:00</p>
                    <p>Сб-Вс: 10:00 - 20:00</p>
                </div>

                <div class="info-card">
                    <div class="info-icon">📞</div>
                    <h4>Контакты</h4>
                    <p>+7 (495) 123-45-67</p>
                    <p>info@beautycute.ru</p>
                </div>
            </div>
        </div>
    </div>

<?php
$getServicesUrl = Url::to(['/appointment/get-services']);
$getFreeTimeUrl = Url::to(['/appointment/get-free-time']);
$saveUrl = Url::to(['/appointment/save']);

$js = <<< JS
    console.log('Скрипт загружен');
    console.log('URL услуг:', '$getServicesUrl');
    console.log('URL времени:', '$getFreeTimeUrl');
    console.log('URL сохранения:', '$saveUrl');
    
    // При изменении мастера
    $('#master-select').on('change', function() {
        var masterId = $(this).val();
        console.log('Выбран мастер:', masterId);
        
        if (masterId) {
            $.getJSON('$getServicesUrl', {master_id: masterId}, function(data) {
                console.log('Получены услуги:', data);
                
                var serviceSelect = $('#service-select');
                serviceSelect.empty();
                serviceSelect.append('<option value="">-- Выберите услугу --</option>');
                
                if (data.length === 0) {
                    serviceSelect.append('<option value="">Нет услуг у этого мастера</option>');
                } else {
                    $.each(data, function(i, service) {
                        serviceSelect.append('<option value="' + service.id + '" data-duration="' + service.duration + '" data-price="' + service.price + '">' + service.name + ' - ' + service.price + ' руб.</option>');
                    });
                }
                
                $('#service-group').slideDown(300);
                $('#service-info').hide();
                $('#date-group').hide();
                $('#time-group').hide();
                $('#payment-group').hide();
                $('#info-group').hide();
                $('#submit-group').hide();
            }).fail(function(jqXHR, textStatus, errorThrown) {
                console.log('Ошибка загрузки услуг:', textStatus, errorThrown);
                showMessage('Ошибка загрузки услуг', 'danger');
            });
        } else {
            $('#service-group').slideUp(300);
            $('#service-info').hide();
            $('#date-group').hide();
            $('#time-group').hide();
            $('#payment-group').hide();
            $('#info-group').hide();
            $('#submit-group').hide();
        }
    });
    
    // При изменении услуги
    $('#service-select').on('change', function() {
        var selected = $(this).find('option:selected');
        console.log('Выбрана услуга:', selected.val(), selected.data('duration'));
        
        if (selected.val()) {
            $('#service-info').html(
                '<div class="service-details">' +
                '<span class="service-name">' + selected.text() + '</span>' +
                '<div class="service-meta">' +
                '<span class="meta-item">⏱️ ' + selected.data('duration') + ' мин.</span>' +
                '</div>' +
                '</div>'
            ).slideDown(300);
            $('#date-group').slideDown(300);
            $('#time-group').hide();
            $('#payment-group').hide();
            $('#info-group').hide();
            $('#submit-group').hide();
        } else {
            $('#service-info').slideUp(300);
            $('#date-group').slideUp(300);
            $('#time-group').hide();
            $('#payment-group').hide();
            $('#info-group').hide();
            $('#submit-group').hide();
        }
    });
    
    // При изменении даты
    $('#date-input').on('change', function() {
        var masterId = $('#master-select').val();
        var serviceId = $('#service-select').val();
        var date = $(this).val();
        
        console.log('Выбрана дата:', date, 'мастер:', masterId, 'услуга:', serviceId);
        
        if (masterId && serviceId && date) {
            $('#time-group').hide();
            $('#time-select').empty().append('<option value="">Загрузка...</option>');
            
            $.getJSON('$getFreeTimeUrl', {
                master_id: masterId,
                service_id: serviceId,
                date: date
            }, function(data) {
                console.log('Получено свободное время:', data);
                
                var timeSelect = $('#time-select');
                timeSelect.empty();
                timeSelect.append('<option value="">-- Выберите время --</option>');
                
                if (data && data.length > 0) {
                    $.each(data, function(i, slot) {
                        timeSelect.append('<option value="' + slot.start + '">' + slot.time + '</option>');
                    });
                    $('#time-group').slideDown(300);
                } else {
                    timeSelect.append('<option value="">Нет свободного времени</option>');
                    $('#time-group').slideDown(300);
                }
                
                $('#payment-group').hide();
                $('#info-group').hide();
                $('#submit-group').hide();
            }).fail(function(jqXHR, textStatus, errorThrown) {
                console.log('Ошибка загрузки времени:', textStatus, errorThrown);
                console.log('Ответ сервера:', jqXHR.responseText);
                
                var timeSelect = $('#time-select');
                timeSelect.empty();
                timeSelect.append('<option value="">Ошибка загрузки</option>');
                $('#time-group').slideDown(300);
            });
        }
    });
    
    // При изменении времени
    $('#time-select').on('change', function() {
        console.log('Выбрано время:', $(this).val());
        
        if ($(this).val() && $(this).val() !== '') {
            $('#payment-group').slideDown(300);
            $('#info-group').slideDown(300);
            $('#submit-group').slideDown(300);
        } else {
            $('#payment-group').slideUp(300);
            $('#info-group').slideUp(300);
            $('#submit-group').slideUp(300);
        }
    });
    
    // Функция показа сообщений
    function showMessage(text, type) {
        var messageDiv = $('#form-message');
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        messageDiv.html('<div class="alert ' + alertClass + '">' + text + '</div>').fadeIn();
        setTimeout(function() {
            messageDiv.fadeOut();
        }, 3000);
    }
    
    // Отправка формы
    $('#appointment-form').on('submit', function(e) {
        e.preventDefault();
        console.log('Форма отправлена');
        
        var data = {
            master_id: $('#master-select').val(),
            service_id: $('#service-select').val(),
            start_time: $('#time-select').val(),
            payment_method: $('#payment-select').val(),
            additional_info: $('#additional-info').val()
        };
        console.log('Данные для отправки:', data);
        
        // Проверка на заполненность
        if (!data.master_id || !data.service_id || !data.start_time || !data.payment_method) {
            showMessage('Заполните все поля', 'danger');
            return;
        }
        
        showMessage('Отправка...', 'info');
        
        $.ajax({
            url: '$saveUrl',
            type: 'POST',
            data: data,
            dataType: 'json',
            success: function(response) {
                console.log('Ответ сервера:', response);
                
                if (response.success) {
                    showMessage(response.message || 'Запись успешно создана!', 'success');
                    $('#appointment-form')[0].reset();
                    $('#service-group, #service-info, #date-group, #time-group, #payment-group, #info-group, #submit-group').slideUp(300);
                } else {
                    var errorMsg = response.message || 'Ошибка при сохранении';
                    if (response.errors) {
                        errorMsg += '<br>' + JSON.stringify(response.errors);
                    }
                    showMessage(errorMsg, 'danger');
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                console.log('Ошибка отправки:', textStatus, errorThrown);
                console.log('Статус:', jqXHR.status);
                console.log('Ответ:', jqXHR.responseText);
                
                var errorMsg = 'Ошибка соединения с сервером';
                if (jqXHR.status === 404) {
                    errorMsg = 'URL не найден (404)';
                } else if (jqXHR.status === 500) {
                    errorMsg = 'Внутренняя ошибка сервера (500)';
                }
                
                showMessage(errorMsg, 'danger');
            }
        });
    });
JS;

$this->registerJs($js);

$css = <<< CSS
    .beauty-appointment {
        max-width: 1200px;
        margin: 0 auto;
        padding: 40px 20px;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    .appointment-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .appointment-header h1 {
        color: #9b59b6;
        font-size: 2.8em;
        font-weight: 600;
        margin-bottom: 15px;
        text-shadow: 2px 2px 4px rgba(155, 89, 182, 0.1);
    }

    .divider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        margin: 20px 0;
    }

    .divider::before,
    .divider::after {
        content: '';
        width: 80px;
        height: 2px;
        background: linear-gradient(90deg, transparent, #9b59b6, #d8b5e6, #9b59b6, transparent);
    }

    .divider-icon {
        font-size: 2em;
        color: #9b59b6;
    }

    .header-description {
        color: #8e44ad;
        font-size: 1.2em;
        max-width: 600px;
        margin: 20px auto 0;
        line-height: 1.6;
    }

    .appointment-container {
        display: grid;
        grid-template-columns: 1.5fr 1fr;
        gap: 30px;
    }

    .appointment-card {
        background: white;
        border-radius: 25px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
    }

    .appointment-card-header {
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        padding: 20px 25px;
    }

    .appointment-card-header h3 {
        color: white;
        margin: 0;
        font-size: 1.5em;
        font-weight: 600;
    }

    .appointment-card-body {
        padding: 30px;
    }

    .beauty-label {
        display: block;
        margin-bottom: 8px;
        color: #8e44ad;
        font-weight: 500;
        font-size: 1em;
    }

    .beauty-select,
    .beauty-input,
    .beauty-textarea {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #f0e5f5;
        border-radius: 12px;
        font-size: 1em;
        transition: all 0.3s ease;
        background: white;
        color: #4a4a4a;
    }

    .beauty-select:focus,
    .beauty-input:focus,
    .beauty-textarea:focus {
        outline: none;
        border-color: #9b59b6;
        box-shadow: 0 0 0 4px rgba(155, 89, 182, 0.1);
    }

    .service-info-card {
        background: #faf5ff;
        border-radius: 12px;
        padding: 20px;
        margin: 20px 0;
        border-left: 4px solid #9b59b6;
    }

    .service-details {
        display: flex;
        justify-content: space-between;
        align-items: center;
        flex-wrap: wrap;
        gap: 15px;
    }

    .service-name {
        font-size: 1.1em;
        font-weight: 600;
        color: #9b59b6;
    }

    .service-meta {
        display: flex;
        gap: 15px;
    }

    .meta-item {
        color: #8e44ad;
        font-size: 0.95em;
    }

    .beauty-submit-btn {
        width: 100%;
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        color: white;
        border: none;
        padding: 15px 30px;
        font-size: 1.2em;
        font-weight: 600;
        border-radius: 50px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 8px 16px rgba(155, 89, 182, 0.3);
        letter-spacing: 1px;
    }

    .beauty-submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(155, 89, 182, 0.4);
    }

    .form-message {
        margin-top: 20px;
    }

    .form-message .alert {
        padding: 15px 20px;
        border-radius: 12px;
        margin: 0;
    }

    .form-message .alert-success {
        background: #d4edda;
        color: #155724;
        border-left: 4px solid #28a745;
    }

    .form-message .alert-danger {
        background: #f8d7da;
        color: #721c24;
        border-left: 4px solid #dc3545;
    }

    .form-message .alert-info {
        background: #d1ecf1;
        color: #0c5460;
        border-left: 4px solid #17a2b8;
    }

    /* Блок с информацией */
    .appointment-info {
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .info-card {
        background: white;
        border-radius: 20px;
        padding: 25px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        transition: all 0.3s ease;
    }

    .info-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(155, 89, 182, 0.2);
    }

    .info-icon {
        font-size: 2.5em;
        margin-bottom: 15px;
        color: #9b59b6;
    }

    .info-card h4 {
        color: #8e44ad;
        font-size: 1.2em;
        font-weight: 600;
        margin-bottom: 15px;
    }

    .info-card ol {
        padding-left: 20px;
        color: #666;
        line-height: 1.8;
    }

    .info-card p {
        color: #666;
        line-height: 1.6;
        margin: 5px 0;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .appointment-header h1 {
            font-size: 2.2em;
        }

        .appointment-container {
            grid-template-columns: 1fr;
        }

        .service-details {
            flex-direction: column;
            text-align: center;
        }
    }

    @media (max-width: 480px) {
        .appointment-header h1 {
            font-size: 1.8em;
        }

        .appointment-card-body {
            padding: 20px;
        }

        .meta-item {
            font-size: 0.9em;
        }
    }

    /* Анимации */
    .form-group {
        animation: fadeInUp 0.5s ease forwards;
        opacity: 0;
    }

    .form-group:nth-child(1) { animation-delay: 0.1s; }
    .form-group:nth-child(2) { animation-delay: 0.2s; }
    .form-group:nth-child(3) { animation-delay: 0.3s; }
    .form-group:nth-child(4) { animation-delay: 0.4s; }
    .form-group:nth-child(5) { animation-delay: 0.5s; }
    .form-group:nth-child(6) { animation-delay: 0.6s; }
    .form-group:nth-child(7) { animation-delay: 0.7s; }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
CSS;

$this->registerCss($css);
?>