<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\LinkPager;

$this->title = 'Каталог услуг';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-catalog">
        <div class="catalog-header">
            <h1><?= Html::encode($this->title) ?></h1>
            <div class="divider">
                <span class="divider-icon">💇‍♀️</span>
            </div>
            <p class="header-description">Выберите услугу и запишитесь к лучшим мастерам</p>
        </div>

        <div class="catalog-container">
            <div class="row">
                <!-- Боковая панель с фильтрами -->
                <div class="col-md-3">
                    <div class="filter-panel">
                        <div class="filter-header">
                            <h3>🔍 Фильтры</h3>
                        </div>
                        <div class="filter-body">
                            <form method="get" action="<?= Url::to(['index']) ?>" id="filter-form">

                                <!-- Поиск -->
                                <div class="filter-group">
                                    <label class="filter-label">Поиск</label>
                                    <div class="input-wrapper">
                                        <span class="input-icon">🔎</span>
                                        <input type="text" name="search" class="filter-input" value="<?= Html::encode($search) ?>" placeholder="Название услуги">
                                    </div>
                                </div>

                                <!-- Категория -->
                                <div class="filter-group">
                                    <label class="filter-label">Категория</label>
                                    <select name="category" class="filter-select">
                                        <option value="">Все категории</option>
                                        <?php foreach ($categories as $category): ?>
                                            <option value="<?= $category->id ?>" <?= $selectedCategory == $category->id ? 'selected' : '' ?>>
                                                <?= Html::encode($category->name) ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>

                                <!-- Цена -->
                                <div class="filter-group">
                                    <label class="filter-label">Цена (руб.)</label>
                                    <div class="price-range">
                                        <div class="price-input">
                                            <span class="price-currency">От</span>
                                            <input type="number" name="min_price" class="filter-input" value="<?= $minPrice ?>" placeholder="0">
                                        </div>
                                        <div class="price-input">
                                            <span class="price-currency">До</span>
                                            <input type="number" name="max_price" class="filter-input" value="<?= $maxPrice ?>" placeholder="10000">
                                        </div>
                                    </div>
                                </div>

                                <!-- Длительность -->
                                <div class="filter-group">
                                    <label class="filter-label">Длительность</label>
                                    <select name="duration" class="filter-select">
                                        <option value="">Любая</option>
                                        <option value="30" <?= $duration == 30 ? 'selected' : '' ?>>⏱️ до 30 мин</option>
                                        <option value="60" <?= $duration == 60 ? 'selected' : '' ?>>⏱️ до 60 мин</option>
                                        <option value="90" <?= $duration == 90 ? 'selected' : '' ?>>⏱️ до 90 мин</option>
                                        <option value="120" <?= $duration == 120 ? 'selected' : '' ?>>⏱️ до 120 мин</option>
                                    </select>
                                </div>

                                <!-- Сортировка -->
                                <div class="filter-group">
                                    <label class="filter-label">Сортировка</label>
                                    <select name="sort" class="filter-select">
                                        <option value="name" <?= $sort == 'name' ? 'selected' : '' ?>>📝 По названию</option>
                                        <option value="price" <?= $sort == 'price' ? 'selected' : '' ?>>💰 По цене</option>
                                        <option value="duration" <?= $sort == 'duration' ? 'selected' : '' ?>>⏰ По длительности</option>
                                    </select>
                                </div>

                                <div class="filter-group">
                                    <select name="order" class="filter-select">
                                        <option value="asc" <?= $order == 'asc' ? 'selected' : '' ?>>↑ По возрастанию</option>
                                        <option value="desc" <?= $order == 'desc' ? 'selected' : '' ?>>↓ По убыванию</option>
                                    </select>
                                </div>

                                <div class="filter-actions">
                                    <button type="submit" class="filter-btn primary">Применить фильтры</button>
                                    <a href="<?= Url::to(['index']) ?>" class="filter-btn secondary">Сбросить</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Список услуг -->
                <div class="col-md-9">
                    <div class="services-grid">
                        <?php if (empty($services)): ?>
                            <div class="empty-state">
                                <div class="empty-icon">🔍</div>
                                <h3>Услуги не найдены</h3>
                                <p>Попробуйте изменить параметры поиска</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($services as $service): ?>
                                <div class="service-card-wrapper">
                                    <div class="service-card">
                                        <div class="service-card-header">
                                            <?php if ($service->category): ?>
                                                <span class="category-badge"><?= Html::encode($service->category->name) ?></span>
                                            <?php endif; ?>
                                            <h3 class="service-title">
                                                <?= Html::a(Html::encode($service->name), ['view', 'id' => $service->id], ['class' => 'service-link']) ?>
                                            </h3>
                                        </div>

                                        <div class="service-card-body">
                                            <p class="service-description">
                                                <?= Html::encode(mb_substr($service->description, 0, 100)) ?>
                                                <?php if (strlen($service->description) > 100): ?>...<?php endif; ?>
                                            </p>

                                            <div class="service-meta">
                                                <div class="meta-item">
                                                    <span class="meta-icon">⏱️</span>
                                                    <span class="meta-label">Длительность:</span>
                                                    <span class="meta-value"><?= $service->duration ?> мин</span>
                                                </div>
                                                <div class="meta-item price">
                                                    <span class="meta-icon">💰</span>
                                                    <span class="meta-label">Цена:</span>
                                                    <span class="meta-value"><?= $service->price ?> ₽</span>
                                                </div>
                                            </div>

                                            <?php
                                            // Проверяем, есть ли мастера для этой услуги
                                            $hasMasters = \app\models\MasterService::find()
                                                ->where(['service_id' => $service->id])
                                                ->exists();
                                            ?>

                                            <div class="service-footer">
                                                <?php if ($hasMasters): ?>
                                                    <div class="masters-status available">
                                                        <span class="status-icon">✅</span>
                                                        <span>Есть мастера</span>
                                                    </div>
                                                    <?= Html::a('Выбрать мастера →', ['view', 'id' => $service->id], [
                                                        'class' => 'service-btn'
                                                    ]) ?>
                                                <?php else: ?>
                                                    <div class="masters-status unavailable">
                                                        <span class="status-icon">❌</span>
                                                        <span>Нет мастеров</span>
                                                    </div>
                                                    <button class="service-btn disabled" disabled>Нет мастеров</button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                            <div class="pagination-wrapper">
                                <?= LinkPager::widget([
                                    'pagination' => $pages,
                                    'options' => ['class' => 'beauty-pagination'],
                                    'linkOptions' => ['class' => 'page-link'],
                                    'activePageCssClass' => 'active',
                                    'disabledPageCssClass' => 'disabled',
                                    'prevPageLabel' => '←',
                                    'nextPageLabel' => '→',
                                ]) ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$css = <<< CSS
    .beauty-catalog {
        max-width: 1400px;
        margin: 0 auto;
        padding: 40px 20px;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    .catalog-header {
        text-align: center;
        margin-bottom: 50px;
    }

    .catalog-header h1 {
        color: #9b59b6;
        font-size: 2.8em;
        font-weight: 600;
        margin-bottom: 15px;
        text-shadow: 2px 2px 4px rgba(155, 89, 182, 0.1);
    }

    .divider {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        margin: 20px 0;
    }

    .divider::before,
    .divider::after {
        content: '';
        width: 80px;
        height: 2px;
        background: linear-gradient(90deg, transparent, #9b59b6, #d8b5e6, #9b59b6, transparent);
    }

    .divider-icon {
        font-size: 2em;
        color: #9b59b6;
    }

    .header-description {
        color: #8e44ad;
        font-size: 1.2em;
        max-width: 600px;
        margin: 20px auto 0;
        line-height: 1.6;
    }

    /* Панель фильтров */
    .filter-panel {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
        position: sticky;
        top: 20px;
        margin-bottom: 30px;
    }

    .filter-header {
        background: linear-gradient(135deg, #9b59b6, #d8b5e6);
        padding: 20px;
    }

    .filter-header h3 {
        color: white;
        margin: 0;
        font-size: 1.3em;
        font-weight: 600;
    }

    .filter-body {
        padding: 25px;
    }

    .filter-group {
        margin-bottom: 20px;
    }

    .filter-label {
        display: block;
        color: #8e44ad;
        font-weight: 500;
        margin-bottom: 8px;
        font-size: 0.95em;
    }

    .input-wrapper {
        position: relative;
    }

    .input-icon {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #9b59b6;
        font-size: 1.1em;
    }

    .filter-input {
        width: 100%;
        padding: 12px 15px 12px 40px;
        border: 2px solid #f0e5f5;
        border-radius: 12px;
        font-size: 0.95em;
        transition: all 0.3s ease;
        background: white;
    }

    .filter-input:focus {
        outline: none;
        border-color: #9b59b6;
        box-shadow: 0 0 0 4px rgba(155, 89, 182, 0.1);
    }

    .filter-select {
        width: 100%;
        padding: 12px 15px;
        border: 2px solid #f0e5f5;
        border-radius: 12px;
        font-size: 0.95em;
        background: white;
        cursor: pointer;
    }

    .filter-select:focus {
        outline: none;
        border-color: #9b59b6;
    }

    .price-range {
        display: flex;
        gap: 10px;
    }

    .price-input {
        flex: 1;
        position: relative;
    }

    .price-currency {
        position: absolute;
        left: 10px;
        top: 50%;
        transform: translateY(-50%);
        color: #9b59b6;
        font-weight: 600;
        font-size: 0.9em;
    }

    .price-input .filter-input {
        padding-left: 35px;
    }

    .filter-actions {
        display: flex;
        gap: 10px;
        margin-top: 25px;
    }

    .filter-btn {
        flex: 1;
        padding: 12px;
        border: none;
        border-radius: 12px;
        font-size: 0.95em;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .filter-btn.primary {
        background: #9b59b6;
        color: white;
    }

    .filter-btn.primary:hover {
        background: #8e44ad;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(155, 89, 182, 0.4);
    }

    .filter-btn.secondary {
        background: #f0e5f5;
        color: #8e44ad;
    }

    .filter-btn.secondary:hover {
        background: #e1d0ec;
    }

    /* Сетка услуг */
    .services-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 25px;
    }

    .service-card-wrapper {
        animation: cardAppear 0.5s ease forwards;
        opacity: 0;
    }

    .service-card {
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
        overflow: hidden;
        transition: all 0.3s ease;
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .service-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 20px 40px rgba(155, 89, 182, 0.25);
    }

    .service-card-header {
        background: linear-gradient(135deg, #faf5ff, white);
        padding: 20px;
        border-bottom: 2px solid #f0e5f5;
        position: relative;
    }

    .category-badge {
        display: inline-block;
        background: #9b59b6;
        color: white;
        padding: 4px 12px;
        border-radius: 50px;
        font-size: 0.85em;
        margin-bottom: 10px;
    }

    .service-title {
        margin: 0;
        font-size: 1.3em;
        line-height: 1.4;
        height: 55px;
        overflow: hidden;
    }

    .service-link {
        color: #8e44ad;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .service-link:hover {
        color: #9b59b6;
    }

    .service-card-body {
        padding: 20px;
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    .service-description {
        color: #666;
        font-size: 0.95em;
        line-height: 1.6;
        margin-bottom: 15px;
        height: 60px;
        overflow: hidden;
    }

    .service-meta {
        margin-bottom: 20px;
    }

    .meta-item {
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 8px 0;
        border-bottom: 1px dashed #f0e5f5;
    }

    .meta-item.price {
        border-bottom: none;
    }

    .meta-icon {
        font-size: 1.2em;
        min-width: 25px;
    }

    .meta-label {
        color: #8e44ad;
        font-size: 0.9em;
    }

    .meta-value {
        font-weight: 600;
        color: #9b59b6;
        margin-left: auto;
    }

    .service-footer {
        margin-top: auto;
    }

    .masters-status {
        display: flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 12px;
        padding: 8px 12px;
        border-radius: 10px;
        font-size: 0.95em;
    }

    .masters-status.available {
        background: #e8f5e9;
        color: #2e7d32;
    }

    .masters-status.unavailable {
        background: #ffebee;
        color: #c62828;
    }

    .status-icon {
        font-size: 1.1em;
    }

    .service-btn {
        display: block;
        width: 100%;
        padding: 12px;
        background: #9b59b6;
        color: white;
        border: none;
        border-radius: 12px;
        font-size: 1em;
        font-weight: 600;
        text-align: center;
        text-decoration: none;
        transition: all 0.3s ease;
        cursor: pointer;
    }

    .service-btn:hover {
        background: #8e44ad;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(155, 89, 182, 0.4);
        color: white;
        text-decoration: none;
    }

    .service-btn.disabled {
        background: #e0e0e0;
        cursor: not-allowed;
        opacity: 0.7;
    }

    .service-btn.disabled:hover {
        transform: none;
        box-shadow: none;
    }

    /* Пустое состояние */
    .empty-state {
        text-align: center;
        padding: 60px 20px;
        background: white;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(155, 89, 182, 0.15);
    }

    .empty-icon {
        font-size: 5em;
        margin-bottom: 20px;
        opacity: 0.5;
    }

    .empty-state h3 {
        color: #8e44ad;
        font-size: 1.8em;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #666;
        font-size: 1.1em;
    }

    /* Пагинация */
    .pagination-wrapper {
        grid-column: 1 / -1;
        margin-top: 30px;
    }

    .beauty-pagination {
        display: flex;
        justify-content: center;
        gap: 5px;
        padding: 0;
        list-style: none;
    }

    .beauty-pagination li {
        display: inline-block;
    }

    .beauty-pagination li a,
    .beauty-pagination li span {
        display: block;
        padding: 10px 15px;
        background: white;
        color: #8e44ad;
        border-radius: 10px;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 2px solid transparent;
    }

    .beauty-pagination li.active a,
    .beauty-pagination li.active span {
        background: #9b59b6;
        color: white;
        border-color: #9b59b6;
    }

    .beauty-pagination li a:hover {
        background: #f0e5f5;
        border-color: #9b59b6;
    }

    .beauty-pagination li.disabled span {
        color: #ccc;
        cursor: not-allowed;
    }

    /* Анимации */
    @keyframes cardAppear {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .service-card-wrapper:nth-child(1) { animation-delay: 0.1s; }
    .service-card-wrapper:nth-child(2) { animation-delay: 0.15s; }
    .service-card-wrapper:nth-child(3) { animation-delay: 0.2s; }
    .service-card-wrapper:nth-child(4) { animation-delay: 0.25s; }
    .service-card-wrapper:nth-child(5) { animation-delay: 0.3s; }
    .service-card-wrapper:nth-child(6) { animation-delay: 0.35s; }
    .service-card-wrapper:nth-child(7) { animation-delay: 0.4s; }
    .service-card-wrapper:nth-child(8) { animation-delay: 0.45s; }
    .service-card-wrapper:nth-child(9) { animation-delay: 0.5s; }
    .service-card-wrapper:nth-child(10) { animation-delay: 0.55s; }
    .service-card-wrapper:nth-child(11) { animation-delay: 0.6s; }
    .service-card-wrapper:nth-child(12) { animation-delay: 0.65s; }

    /* Адаптивность */
    @media (max-width: 768px) {
        .catalog-header h1 {
            font-size: 2.2em;
        }

        .services-grid {
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 15px;
        }

        .filter-panel {
            position: static;
        }
    }

    @media (max-width: 480px) {
        .catalog-header h1 {
            font-size: 1.8em;
        }

        .services-grid {
            grid-template-columns: 1fr;
        }

        .price-range {
            flex-direction: column;
            gap: 5px;
        }

        .filter-actions {
            flex-direction: column;
        }
    }
CSS;

$this->registerCss($css);
?>