<?php
use yii\helpers\Url;
use yii\helpers\Html;

$this->title = 'Панель мастера';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="master-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-lg-3 col-md-6">
            <div class="panel panel-primary">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-user" style="font-size: 45px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 24px;">Профиль</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Редактировать профиль', ['profile'], ['class' => 'btn btn-primary btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-cutlery" style="font-size: 45px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 24px;">Услуги</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Мои услуги', ['services'], ['class' => 'btn btn-success btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-calendar" style="font-size: 45px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 24px;">Расписание</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Моё расписание', ['schedule'], ['class' => 'btn btn-info btn-block']) ?>
                </div>
            </div>
        </div>

        <div class="col-lg-3 col-md-6">
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-picture" style="font-size: 45px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 24px;">Портфолио</div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <?= Html::a('Моё портфолио', ['portfolio'], ['class' => 'btn btn-warning btn-block']) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Мои записи (клиенты)</h3>
                </div>
                <div class="panel-body">
                    <?= Html::a('Посмотреть все записи', ['appointments'], ['class' => 'btn btn-primary']) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Информация о мастере</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <tr>
                            <th>ФИО:</th>
                            <td><?= Html::encode($user->surname . ' ' . $user->name . ' ' . $user->patronymic) ?></td>
                        </tr>
                        <tr>
                            <th>Телефон:</th>
                            <td><?= Html::encode($user->phone_number) ?></td>
                        </tr>
                        <tr>
                            <th>Специализация:</th>
                            <td><?= Html::encode($masterInfo->specialization ?: 'Не указана') ?></td>
                        </tr>
                        <tr>
                            <th>Опыт:</th>
                            <td><?= $masterInfo->experience_years ? $masterInfo->experience_years . ' лет' : 'Не указан' ?></td>
                        </tr>
                        <tr>
                            <th>Статус:</th>
                            <td>
                                <?php if ($masterInfo->is_active): ?>
                                    <span class="label label-success">Активен</span>
                                <?php else: ?>
                                    <span class="label label-danger">Неактивен</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">О себе</h3>
                </div>
                <div class="panel-body">
                    <?= $masterInfo->bio ? nl2br(Html::encode($masterInfo->bio)) : '<em>Не заполнено</em>' ?>
                </div>
            </div>
        </div>
    </div>
</div>