<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

$this->title = $user->surname . ' ' . $user->name;
$this->params['breadcrumbs'][] = ['label' => 'Мастера', 'url' => ['/site/masters']];
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-master-profile">

        <!-- Шапка профиля -->
        <div class="profile-header">
            <div class="profile-header-bg"></div>
            <div class="container">
                <div class="profile-header-content">
                    <div class="profile-avatar">
                        <?php
                        $initials = strtoupper(substr($user->name, 0, 1) . substr($user->surname, 0, 1));
                        $colors = ['#b3456b', '#d46b91', '#a65a72', '#c47894', '#e396b2'];
                        $colorIndex = ($user->id - 1) % count($colors);
                        ?>
                        <div class="avatar-circle" style="background: <?= $colors[$colorIndex] ?>;">
                            <span class="avatar-text"><?= $initials ?></span>
                        </div>

                        <?php if ($masterInfo->is_active): ?>
                            <div class="status-badge active" title="Принимает клиентов">
                                <span class="status-dot"></span>
                            </div>
                        <?php else: ?>
                            <div class="status-badge inactive" title="Временно не принимает">
                                <span class="status-dot"></span>
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="profile-info">
                        <h1 class="profile-name">
                            <?= Html::encode($user->surname . ' ' . $user->name . ' ' . $user->patronymic) ?>
                        </h1>

                        <div class="profile-status">
                            <?php if ($masterInfo->is_active): ?>
                                <span class="status active">✅ Принимает клиентов</span>
                            <?php else: ?>
                                <span class="status inactive">⏳ Временно не принимает</span>
                            <?php endif; ?>
                        </div>

                        <div class="profile-contact">
                            <div class="contact-item">
                                <span class="contact-icon">📞</span>
                                <span class="contact-text"><?= Html::encode($user->phone_number) ?></span>
                            </div>
                        </div>

                        <?php if ($masterInfo->specialization): ?>
                            <div class="profile-specialization">
                                <span class="spec-badge"><?= Html::encode($masterInfo->specialization) ?></span>
                            </div>
                        <?php endif; ?>

                        <div class="profile-stats">
                            <?php if ($masterInfo->experience_years): ?>
                                <div class="stat-item">
                                    <span class="stat-icon">⭐</span>
                                    <span class="stat-value"><?= $masterInfo->experience_years ?> лет</span>
                                    <span class="stat-label">опыта</span>
                                </div>
                            <?php endif; ?>

                            <?php if ($masterInfo->certificate_expiry): ?>
                                <div class="stat-item">
                                    <span class="stat-icon">📜</span>
                                    <span class="stat-value"><?= Yii::$app->formatter->asDate($masterInfo->certificate_expiry) ?></span>
                                    <span class="stat-label">действие сертификата</span>
                                </div>
                            <?php endif; ?>

                            <div class="stat-item">
                                <span class="stat-icon">💇</span>
                                <span class="stat-value"><?= count($services) ?></span>
                                <span class="stat-label">услуг</span>
                            </div>
                        </div>

                        <?php if ($masterInfo->certificate_photo): ?>
                            <div class="profile-certificate">
                                <?= Html::a('📄 Посмотреть сертификат', '/' . $masterInfo->certificate_photo, [
                                    'class' => 'certificate-link',
                                    'target' => '_blank'
                                ]) ?>
                            </div>
                        <?php endif; ?>

                        <div class="profile-actions">
                            <?= Html::a('✏️ Записаться к мастеру', ['/appointment/create'], [
                                'class' => 'btn book-btn',
                                'data' => ['method' => 'post']
                            ]) ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container profile-content">
            <!-- О себе -->
            <?php if ($masterInfo->bio): ?>
                <div class="section-card bio-section">
                    <div class="section-header">
                        <h2>О себе</h2>
                        <div class="section-divider"></div>
                    </div>
                    <div class="bio-content">
                        <?= nl2br(Html::encode($masterInfo->bio)) ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Услуги и график -->
            <div class="services-schedule-row">
                <!-- Услуги и цены -->
                <div class="services-section">
                    <div class="section-header">
                        <h2>Услуги и цены</h2>
                        <div class="section-divider"></div>
                    </div>

                    <div class="services-list">
                        <?php if (empty($services)): ?>
                            <div class="empty-state">
                                <p>У мастера пока нет услуг</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($services as $service): ?>
                                <?php
                                $finalPrice = $service->price;
                                if (!empty($service->price_modifier)) {
                                    $finalPrice += $service->price_modifier;
                                }
                                ?>
                                <div class="service-item">
                                    <div class="service-info">
                                        <div class="service-name">
                                            <strong><?= Html::encode($service->name) ?></strong>
                                            <?php if ($service->description): ?>
                                                <p class="service-desc"><?= Html::encode($service->description) ?></p>
                                            <?php endif; ?>
                                        </div>
                                        <div class="service-duration">
                                            <span class="duration-icon">⏱️</span>
                                            <?= $service->duration ?> мин.
                                        </div>
                                    </div>
                                    <div class="service-price">
                                        <span class="price-value"><?= $finalPrice ?></span>
                                        <span class="price-currency">₽</span>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- График работы -->
                <div class="schedule-section">
                    <div class="section-header">
                        <h2>График работы</h2>
                        <div class="section-divider"></div>
                    </div>

                    <div class="schedule-list">
                        <?php
                        $days = [
                            1 => 'Понедельник',
                            2 => 'Вторник',
                            3 => 'Среда',
                            4 => 'Четверг',
                            5 => 'Пятница',
                            6 => 'Суббота',
                            7 => 'Воскресенье',
                        ];
                        ?>

                        <?php if (empty($schedule)): ?>
                            <div class="empty-state">
                                <p>Расписание не указано</p>
                            </div>
                        <?php else: ?>
                            <?php foreach ($days as $num => $dayName): ?>
                                <div class="schedule-item <?= isset($schedule[$num]) && $schedule[$num]->is_working ? 'working' : 'day-off' ?>">
                                    <span class="day-name"><?= $dayName ?></span>
                                    <?php if (isset($schedule[$num]) && $schedule[$num]->is_working): ?>
                                        <span class="work-time">
                                        <?= Yii::$app->formatter->asTime($schedule[$num]->start_time, 'php:H:i') ?> —
                                        <?= Yii::$app->formatter->asTime($schedule[$num]->end_time, 'php:H:i') ?>
                                    </span>
                                    <?php else: ?>
                                        <span class="day-off-label">Выходной</span>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>

                    <?php if ($masterInfo->is_active): ?>
                        <div class="availability-note">
                            <span class="note-icon">✅</span>
                            <span>Мастер принимает клиентов в рабочее время</span>
                        </div>
                    <?php else: ?>
                        <div class="availability-note warning">
                            <span class="note-icon">⏳</span>
                            <span>Мастер временно не принимает клиентов</span>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Портфолио -->
            <?php if (!empty($portfolio)): ?>
                <div class="portfolio-section">
                    <div class="section-header">
                        <h2>Портфолио</h2>
                        <div class="section-divider"></div>
                    </div>

                    <div class="portfolio-grid">
                        <?php foreach ($portfolio as $photo): ?>
                            <div class="portfolio-item">
                                <a href="/<?= $photo->photo_url ?>" target="_blank" class="portfolio-link">
                                    <img src="/<?= $photo->photo_url ?>" alt="Работа мастера" class="portfolio-img">
                                    <?php if ($photo->description): ?>
                                        <div class="portfolio-overlay">
                                            <p class="portfolio-desc"><?= Html::encode($photo->description) ?></p>
                                        </div>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Отзывы (заглушка) -->
            <div class="reviews-section">
                <div class="section-header">
                    <h2>Отзывы клиентов</h2>
                    <div class="section-divider"></div>
                </div>

                <div class="reviews-placeholder">
                    <div class="placeholder-icon">💬</div>
                    <p class="placeholder-text">Здесь будут отзывы клиентов. Скоро добавим!</p>
                </div>
            </div>
        </div>
    </div>

<?php
$css = <<< CSS
    .beauty-master-profile {
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
        color: #4a4a4a;
    }

    /* Шапка профиля */
    .profile-header {
        background: linear-gradient(135deg, #fff5f8, #ffe4ed);
        position: relative;
        padding: 60px 0 40px;
        margin-bottom: 40px;
    }

    .profile-header-bg {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-image: radial-gradient(circle at 20% 50%, rgba(179,69,107,0.05) 0%, transparent 50%);
        pointer-events: none;
    }

    .profile-header-content {
        display: flex;
        gap: 40px;
        align-items: center;
        position: relative;
        z-index: 1;
        flex-wrap: wrap;
    }

    .profile-avatar {
        position: relative;
        width: 200px;
        height: 200px;
        flex-shrink: 0;
    }

    .avatar-circle {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 15px 30px rgba(179,69,107,0.3);
        animation: float 3s ease-in-out infinite;
    }

    .avatar-text {
        font-size: 72px;
        font-weight: 600;
        color: white;
        text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
    }

    @keyframes float {
        0%, 100% { transform: translateY(0); }
        50% { transform: translateY(-10px); }
    }

    .status-badge {
        position: absolute;
        bottom: 15px;
        right: 15px;
        width: 35px;
        height: 35px;
        border-radius: 50%;
        background: white;
        display: flex;
        align-items: center;
        justify-content: center;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
    }

    .status-dot {
        width: 20px;
        height: 20px;
        border-radius: 50%;
    }

    .status-badge.active .status-dot {
        background: #4caf50;
        box-shadow: 0 0 15px #4caf50;
    }

    .status-badge.inactive .status-dot {
        background: #ff9800;
        box-shadow: 0 0 15px #ff9800;
    }

    .profile-info {
        flex: 1;
    }

    .profile-name {
        color: #b3456b;
        font-size: 2.8em;
        font-weight: 600;
        margin: 0 0 15px;
        text-shadow: 2px 2px 4px rgba(179,69,107,0.1);
    }

    .profile-status {
        margin-bottom: 20px;
    }

    .status.active {
        color: #4caf50;
        font-weight: 600;
        font-size: 1.1em;
    }

    .status.inactive {
        color: #ff9800;
        font-weight: 600;
        font-size: 1.1em;
    }

    .profile-contact {
        margin-bottom: 15px;
    }

    .contact-item {
        display: inline-flex;
        align-items: center;
        gap: 10px;
        background: white;
        padding: 8px 20px;
        border-radius: 50px;
        box-shadow: 0 4px 8px rgba(179,69,107,0.1);
    }

    .contact-icon {
        font-size: 1.2em;
    }

    .contact-text {
        color: #666;
        font-size: 1.1em;
    }

    .profile-specialization {
        margin-bottom: 20px;
    }

    .spec-badge {
        background: white;
        color: #b3456b;
        padding: 8px 25px;
        border-radius: 50px;
        font-size: 1.1em;
        font-weight: 600;
        box-shadow: 0 4px 8px rgba(179,69,107,0.1);
        display: inline-block;
    }

    .profile-stats {
        display: flex;
        gap: 30px;
        margin: 25px 0;
        flex-wrap: wrap;
    }

    .stat-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        min-width: 120px;
    }

    .stat-icon {
        font-size: 1.8em;
        margin-bottom: 5px;
    }

    .stat-value {
        font-size: 1.4em;
        font-weight: 700;
        color: #b3456b;
    }

    .stat-label {
        color: #a65a72;
        font-size: 0.9em;
    }

    .profile-certificate {
        margin: 20px 0;
    }

    .certificate-link {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #b3456b;
        text-decoration: none;
        font-weight: 600;
        padding: 8px 20px;
        background: white;
        border-radius: 50px;
        box-shadow: 0 4px 8px rgba(179,69,107,0.1);
        transition: all 0.3s ease;
    }

    .certificate-link:hover {
        transform: translateY(-2px);
        box-shadow: 0 8px 16px rgba(179,69,107,0.2);
    }

    .profile-actions {
        margin-top: 25px;
    }

    .book-btn {
        background: linear-gradient(135deg, #b3456b, #d46b91);
        color: white;
        border: none;
        padding: 16px 40px;
        font-size: 1.2em;
        font-weight: 600;
        border-radius: 50px;
        text-decoration: none;
        display: inline-block;
        transition: all 0.3s ease;
        box-shadow: 0 8px 16px rgba(179,69,107,0.3);
    }

    .book-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(179,69,107,0.4);
        color: white;
    }

    /* Контент */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 20px;
    }

    .profile-content {
        padding-bottom: 60px;
    }

    .section-card {
        background: white;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(179,69,107,0.1);
        margin-bottom: 40px;
    }

    .section-header {
        text-align: center;
        margin-bottom: 30px;
    }

    .section-header h2 {
        color: #b3456b;
        font-size: 2.2em;
        font-weight: 600;
        margin-bottom: 10px;
    }

    .section-divider {
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #b3456b, #d46b91);
        margin: 0 auto;
        border-radius: 3px;
    }

    /* Био */
    .bio-content {
        font-size: 1.1em;
        line-height: 1.8;
        color: #666;
        text-align: center;
        max-width: 800px;
        margin: 0 auto;
    }

    /* Услуги и график */
    .services-schedule-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 30px;
        margin-bottom: 40px;
    }

    .services-section,
    .schedule-section {
        background: white;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(179,69,107,0.1);
    }

    .services-list {
        margin-top: 20px;
    }

    .service-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px 0;
        border-bottom: 1px solid #f0d9e3;
    }

    .service-item:last-child {
        border-bottom: none;
    }

    .service-info {
        flex: 1;
    }

    .service-name {
        color: #4a4a4a;
    }

    .service-desc {
        color: #a65a72;
        font-size: 0.9em;
        margin: 5px 0 0;
    }

    .service-duration {
        color: #888;
        font-size: 0.9em;
        margin-top: 5px;
    }

    .duration-icon {
        margin-right: 5px;
    }

    .service-price {
        font-size: 1.4em;
        font-weight: 700;
        color: #b3456b;
        margin-left: 20px;
    }

    .price-currency {
        font-size: 0.8em;
        margin-left: 2px;
    }

    .schedule-list {
        margin-top: 20px;
    }

    .schedule-item {
        display: flex;
        justify-content: space-between;
        padding: 12px 0;
        border-bottom: 1px solid #f0d9e3;
    }

    .schedule-item:last-child {
        border-bottom: none;
    }

    .schedule-item.working {
        color: #4a4a4a;
    }

    .schedule-item.day-off {
        color: #999;
        font-style: italic;
    }

    .day-name {
        font-weight: 600;
    }

    .work-time {
        color: #4caf50;
        font-weight: 500;
    }

    .day-off-label {
        color: #ff9800;
    }

    .availability-note {
        margin-top: 25px;
        padding: 15px;
        background: #e8f5e9;
        border-radius: 10px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .availability-note.warning {
        background: #fff3e0;
    }

    .note-icon {
        font-size: 1.2em;
    }

    /* Портфолио */
    .portfolio-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 25px;
    }

    .portfolio-item {
        position: relative;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        transition: all 0.3s ease;
    }

    .portfolio-item:hover {
        transform: scale(1.05);
        box-shadow: 0 20px 30px rgba(179,69,107,0.3);
    }

    .portfolio-link {
        display: block;
        position: relative;
        text-decoration: none;
    }

    .portfolio-img {
        width: 100%;
        height: 250px;
        object-fit: cover;
        display: block;
    }

    .portfolio-overlay {
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        background: linear-gradient(to top, rgba(179,69,107,0.9), transparent);
        color: white;
        padding: 20px;
        transform: translateY(100%);
        transition: transform 0.3s ease;
    }

    .portfolio-item:hover .portfolio-overlay {
        transform: translateY(0);
    }

    .portfolio-desc {
        margin: 0;
        font-size: 0.95em;
        line-height: 1.4;
    }

    /* Отзывы */
    .reviews-section {
        background: white;
        border-radius: 20px;
        padding: 30px;
        box-shadow: 0 10px 30px rgba(179,69,107,0.1);
    }

    .reviews-placeholder {
        text-align: center;
        padding: 40px;
    }

    .placeholder-icon {
        font-size: 4em;
        margin-bottom: 20px;
        opacity: 0.5;
    }

    .placeholder-text {
        color: #a65a72;
        font-size: 1.2em;
    }

    /* Адаптивность */
    @media (max-width: 768px) {
        .profile-header-content {
            flex-direction: column;
            text-align: center;
        }

        .profile-name {
            font-size: 2.2em;
        }

        .profile-stats {
            justify-content: center;
        }

        .services-schedule-row {
            grid-template-columns: 1fr;
        }

        .portfolio-grid {
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        }
    }

    @media (max-width: 480px) {
        .profile-avatar {
            width: 150px;
            height: 150px;
        }

        .avatar-text {
            font-size: 54px;
        }

        .profile-name {
            font-size: 1.8em;
        }

        .stat-item {
            min-width: 80px;
        }

        .service-item {
            flex-direction: column;
            text-align: center;
            gap: 10px;
        }

        .service-price {
            margin-left: 0;
        }
    }

    /* Анимации */
    .section-card,
    .services-section,
    .schedule-section,
    .portfolio-section,
    .reviews-section {
        animation: fadeInUp 0.5s ease forwards;
        opacity: 0;
    }

    .services-section { animation-delay: 0.2s; }
    .schedule-section { animation-delay: 0.3s; }
    .portfolio-section { animation-delay: 0.4s; }
    .reviews-section { animation-delay: 0.5s; }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
CSS;

$this->registerCss($css);
?>