<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = 'Редактирование профиля';
$this->params['breadcrumbs'][] = ['label' => 'Мой профиль', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="profile-edit">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-lg-6">
            <div class="panel panel-default">
                <div class="panel-body">

                    <?php $form = ActiveForm::begin(); ?>

                    <div class="row">
                        <div class="col-lg-4">
                            <?= $form->field($user, 'surname')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-lg-4">
                            <?= $form->field($user, 'name')->textInput(['maxlength' => true]) ?>
                        </div>
                        <div class="col-lg-4">
                            <?= $form->field($user, 'patronymic')->textInput(['maxlength' => true]) ?>
                        </div>
                    </div>

                    <?= $form->field($user, 'phone_number')->textInput(['maxlength' => true]) ?>

                    <hr>

                    <div class="alert alert-info">
                        <i class="glyphicon glyphicon-info-sign"></i>
                        Если не хотите менять пароль, оставьте поля пустыми.
                    </div>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="control-label">Новый пароль</label>
                                <input type="password" name="new_password" class="form-control" autocomplete="new-password">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="control-label">Подтверждение пароля</label>
                                <input type="password" name="confirm_password" class="form-control" autocomplete="new-password">
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <?= Html::submitButton('Сохранить', ['class' => 'btn btn-success']) ?>
                        <?= Html::a('Отмена', ['index'], ['class' => 'btn btn-default']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>

                </div>
            </div>
        </div>
    </div>
</div>