<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мой профиль';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="profile-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <!-- Приветствие -->
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    <h3>Здравствуйте, <?= Html::encode($user->name) ?>!</h3>
                    <p>Это ваш личный кабинет. Здесь вы можете управлять своим профилем и просматривать историю записей.</p>
                    <?= Html::a('Редактировать профиль', ['edit'], ['class' => 'btn btn-primary']) ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Статистика -->
    <div class="row">
        <div class="col-md-3">
            <div class="panel panel-info">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-calendar" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= $stats['total'] ?></div>
                            <div>Всего записей</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-warning">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-time" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= $stats['pending'] ?></div>
                            <div>Новых</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-success">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-ok" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= $stats['confirmed'] ?></div>
                            <div>Подтверждено</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="panel panel-danger">
                <div class="panel-heading">
                    <div class="row">
                        <div class="col-xs-3">
                            <i class="glyphicon glyphicon-remove" style="font-size: 40px;"></i>
                        </div>
                        <div class="col-xs-9 text-right">
                            <div style="font-size: 30px;"><?= $stats['cancelled'] ?></div>
                            <div>Отменено</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Ближайшая запись -->
    <?php if ($nextAppointment): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-success">
                    <div class="panel-heading">
                        <h3 class="panel-title">Ближайшая запись</h3>
                    </div>
                    <div class="panel-body">
                        <div class="media">
                            <div class="media-left">
                                <div class="avatar-circle" style="width: 60px; height: 60px; background: #5cb85c; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-size: 24px;">
                                    <?= strtoupper(substr($nextAppointment->masterInfo->user->name, 0, 1)) ?>
                                </div>
                            </div>
                            <div class="media-body">
                                <h4 class="media-heading">
                                    <?= Html::encode($nextAppointment->masterInfo->user->surname . ' ' . $nextAppointment->masterInfo->user->name) ?>
                                    <small>
                                        <?php if ($nextAppointment->status == 0): ?>
                                            <span class="label label-warning">Новая</span>
                                        <?php elseif ($nextAppointment->status == 1): ?>
                                            <span class="label label-success">Подтверждена</span>
                                        <?php endif; ?>
                                    </small>
                                </h4>
                                <p>
                                    <strong>Услуга:</strong> <?= Html::encode($nextAppointment->service->name) ?><br>
                                    <strong>Дата и время:</strong> <?= Yii::$app->formatter->asDatetime($nextAppointment->start_time) ?><br>
                                    <strong>Длительность:</strong> <?= $nextAppointment->service->duration ?> мин.<br>
                                    <strong>Оплата:</strong>
                                    <?php
                                    $methods = ['cash' => 'Наличные', 'card' => 'Карта', 'online' => 'Онлайн'];
                                    echo $methods[$nextAppointment->payment_method] ?? $nextAppointment->payment_method;
                                    ?>
                                </p>
                                <?= Html::a('Подробнее', ['view-appointment', 'id' => $nextAppointment->id], ['class' => 'btn btn-sm btn-primary']) ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Последние записи -->
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Последние записи</h3>
                </div>
                <div class="panel-body">
                    <?php if (empty($appointments)): ?>
                        <p class="text-muted">У вас пока нет записей.</p>
                        <?= Html::a('Записаться к мастеру', ['/appointment/create'], ['class' => 'btn btn-success']) ?>
                    <?php else: ?>
                        <table class="table table-striped">
                            <thead>
                            <tr>
                                <th>Дата</th>
                                <th>Мастер</th>
                                <th>Услуга</th>
                                <th>Статус</th>
                                <th></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach (array_slice($appointments, 0, 5) as $appointment): ?>
                                <tr>
                                    <td><?= Yii::$app->formatter->asDatetime($appointment->start_time, 'php:d.m.Y H:i') ?></td>
                                    <td><?= Html::encode($appointment->masterInfo->user->surname . ' ' . $appointment->masterInfo->user->name) ?></td>
                                    <td><?= Html::encode($appointment->service->name) ?></td>
                                    <td>
                                        <?php if ($appointment->status == 0): ?>
                                            <span class="label label-warning">Новая</span>
                                        <?php elseif ($appointment->status == 1): ?>
                                            <span class="label label-success">Подтверждена</span>
                                        <?php elseif ($appointment->status == 2): ?>
                                            <span class="label label-danger">Отменена</span>
                                        <?php elseif ($appointment->status == 3): ?>
                                            <span class="label label-default">Завершена</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?= Html::a('Подробнее', ['view-appointment', 'id' => $appointment->id], ['class' => 'btn btn-sm btn-primary']) ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <?= Html::a('Вся история', ['history'], ['class' => 'btn btn-default']) ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>