<?php

/** @var yii\web\View $this */
/** @var yii\bootstrap5\ActiveForm $form */
/** @var app\models\LoginForm $model */

use yii\bootstrap5\ActiveForm;
use yii\bootstrap5\Html;
use yii\widgets\MaskedInput;

$this->title = 'Авторизация';
$this->params['breadcrumbs'][] = $this->title;
?>

    <div class="beauty-login">
        <div class="login-container">
            <div class="login-header">
                <h1><?= Html::encode($this->title) ?></h1>
                <p class="subtitle">Войдите, чтобы продолжить</p>
            </div>

            <div class="login-form-wrapper">
                <?php $form = ActiveForm::begin([
                    'id' => 'login-form',
                    'options' => ['class' => 'beauty-form'],
                    'fieldConfig' => [
                        'template' => "{label}\n<div class=\"input-wrapper\">{input}</div>\n{error}",
                        'labelOptions' => ['class' => 'beauty-label'],
                        'inputOptions' => ['class' => 'beauty-input'],
                        'errorOptions' => ['class' => 'beauty-error'],
                    ],
                ]); ?>

                <div class="form-group">
                    <?= $form->field($model, 'phone_number')->widget(MaskedInput::class, [
                        'mask' => '+7(999)999-99-99',
                        'options' => [
                            'class' => 'beauty-input',
                            'placeholder' => '+7(999)999-99-99',
                        ],
                    ]) ?>
                </div>

                <div class="form-group">
                    <?= $form->field($model, 'password')->passwordInput([
                        'class' => 'beauty-input',
                        'placeholder' => 'Введите пароль',
                    ]) ?>
                </div>

                <div class="form-group remember-me">
                    <?= $form->field($model, 'rememberMe', [
                        'template' => "<div class=\"custom-checkbox\">{input} {label}</div>\n{error}",
                    ])->checkbox([
                        'class' => 'beauty-checkbox',
                        'label' => 'Запомнить меня',
                        'labelOptions' => ['class' => 'checkbox-label'],
                    ]) ?>
                </div>

                <div class="form-actions">
                    <?= Html::submitButton('🌸 Войти', [
                        'class' => 'beauty-submit-btn',
                        'name' => 'login-button',
                    ]) ?>
                </div>

                <div class="login-footer">
                    <p>Ещё нет аккаунта? <?= Html::a('Зарегистрироваться', ['/site/register']) ?></p>
                </div>

                <?php ActiveForm::end(); ?>
            </div>
        </div>
    </div>

<?php
$css = <<< CSS
    .beauty-login {
        min-height: 100vh;
        background: linear-gradient(135deg, #fdf2f8 0%, #f8e1e8 100%);
        padding: 40px 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    .login-container {
        max-width: 450px;
        width: 100%;
        background: white;
        border-radius: 30px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1), 0 8px 16px rgba(198, 112, 148, 0.2);
        padding: 40px;
        position: relative;
        overflow: hidden;
    }

    .login-container::before {
        content: '';
        position: absolute;
        top: -50px;
        right: -50px;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, #ffd1dc 0%, transparent 70%);
        border-radius: 50%;
        z-index: 0;
    }

    .login-container::after {
        content: '';
        position: absolute;
        bottom: -50px;
        left: -50px;
        width: 250px;
        height: 250px;
        background: radial-gradient(circle, #ffe4ed 0%, transparent 70%);
        border-radius: 50%;
        z-index: 0;
    }

    .login-header {
        text-align: center;
        margin-bottom: 30px;
        position: relative;
        z-index: 1;
    }

    .login-header h1 {
        color: #b3456b;
        font-size: 2.2em;
        font-weight: 600;
        margin: 0 0 10px 0;
        text-shadow: 2px 2px 4px rgba(179, 69, 107, 0.1);
    }

    .subtitle {
        color: #a65a72;
        font-size: 1.1em;
        margin: 0;
    }

    .login-form-wrapper {
        position: relative;
        z-index: 1;
    }

    .beauty-form {
        width: 100%;
    }

    .form-group {
        margin-bottom: 25px;
    }

    .beauty-label {
        display: block;
        margin-bottom: 8px;
        color: #7a4b5f;
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .input-wrapper {
        position: relative;
    }

    .beauty-input {
        width: 100%;
        padding: 14px 18px;
        border: 2px solid #f0d9e3;
        border-radius: 15px;
        font-size: 15px;
        transition: all 0.3s ease;
        background: white;
        color: #4a4a4a;
    }

    .beauty-input:focus {
        outline: none;
        border-color: #b3456b;
        box-shadow: 0 0 0 4px rgba(179, 69, 107, 0.1);
    }

    .beauty-input::placeholder {
        color: #c9a5b6;
        font-style: italic;
    }

    .beauty-error {
        color: #e74c3c;
        font-size: 13px;
        margin-top: 5px;
        padding-left: 15px;
        position: relative;
    }

    .beauty-error::before {
        content: '⚠️';
        position: absolute;
        left: -5px;
        top: 0;
        font-size: 12px;
    }

    .remember-me {
        margin: 20px 0;
    }

    .custom-checkbox {
        display: flex;
        align-items: center;
        gap: 10px;
        cursor: pointer;
    }

    .beauty-checkbox {
        width: 20px;
        height: 20px;
        cursor: pointer;
        accent-color: #b3456b;
    }

    .checkbox-label {
        color: #7a4b5f;
        font-size: 15px;
        cursor: pointer;
        user-select: none;
    }

    .form-actions {
        text-align: center;
        margin: 30px 0 20px;
    }

    .beauty-submit-btn {
        background: linear-gradient(135deg, #b3456b, #d46b91);
        color: white;
        border: none;
        padding: 16px 40px;
        font-size: 1.2em;
        font-weight: 600;
        border-radius: 50px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 8px 16px rgba(179, 69, 107, 0.3);
        letter-spacing: 1px;
        position: relative;
        overflow: hidden;
        width: 100%;
    }

    .beauty-submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(179, 69, 107, 0.4);
    }

    .beauty-submit-btn:active {
        transform: translateY(0);
    }

    .beauty-submit-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .beauty-submit-btn:hover::before {
        left: 100%;
    }

    .login-footer {
        text-align: center;
        margin-top: 25px;
    }

    .login-footer p {
        margin: 10px 0;
        color: #a65a72;
    }

    .login-footer a {
        color: #b3456b;
        text-decoration: none;
        font-weight: 600;
        border-bottom: 2px solid transparent;
        transition: border-color 0.3s ease;
    }

    .login-footer a:hover {
        border-bottom-color: #b3456b;
    }

    /* Анимации для полей */
    .beauty-input {
        animation: fadeInUp 0.5s ease forwards;
        opacity: 0;
    }

    .form-group:nth-child(1) .beauty-input { animation-delay: 0.1s; }
    .form-group:nth-child(2) .beauty-input { animation-delay: 0.2s; }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Адаптивность */
    @media (max-width: 480px) {
        .login-container {
            padding: 30px 20px;
        }

        .login-header h1 {
            font-size: 1.8em;
        }
    }
CSS;

$this->registerCss($css);
?>