<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\widgets\MaskedInput;

$this->title = 'Регистрация';
?>

    <div class="beauty-registration">
        <div class="registration-container">
            <div class="registration-header">
                <h1><?= Html::encode($this->title) ?></h1>
                <p class="subtitle">Присоединяйтесь к нашему сообществу красоты</p>
            </div>

            <?php $form = ActiveForm::begin([
                'id' => 'registration-form',
                'options' => ['class' => 'beauty-form'],
                'fieldConfig' => [
                    'template' => "{label}\n<div class=\"input-wrapper\">{input}</div>\n{hint}\n{error}",
                    'labelOptions' => ['class' => 'beauty-label'],
                    'inputOptions' => ['class' => 'beauty-input'],
                    'errorOptions' => ['class' => 'beauty-error'],
                ],
            ]); ?>

            <div class="role-selection">
                <label class="beauty-label">Выберите роль</label>
                <div class="role-buttons">
                    <?= $form->field($model, 'is_admin', [
                        'template' => "{input}",
                    ])->radioList([
                        0 => 'Я клиент',
                        1 => 'Я мастер',
                    ], [
                        'item' => function($index, $label, $name, $checked, $value) {
                            $checkedAttr = $checked ? 'checked' : '';
                            $activeClass = $checked ? 'active' : '';
                            $icon = $value == 0 ? '👤' : '💇';
                            $bgColor = $value == 0 ? '#4361ee' : '#b3456b';
                            return "<label class='role-btn $activeClass' style='" . ($checked ? "background: $bgColor; border-color: $bgColor;" : "") . "'>" .
                                "<input type='radio' name='$name' value='$value' $checkedAttr style='display:none;'>" .
                                "<span class='role-icon'>$icon</span>" .
                                "<span class='role-text'>$label</span>" .
                                "</label>";
                        },
                        'class' => 'role-radio-group',
                    ]) ?>
                </div>
            </div>

            <div class="form-row">
                <div class="form-col-4">
                    <?= $form->field($model, 'surname')->textInput(['placeholder' => 'Введите фамилию']) ?>
                </div>
                <div class="form-col-4">
                    <?= $form->field($model, 'name')->textInput(['placeholder' => 'Введите имя']) ?>
                </div>
                <div class="form-col-4">
                    <?= $form->field($model, 'patronymic')->textInput(['placeholder' => 'Введите отчество']) ?>
                </div>
            </div>

            <div class="form-row">
                <div class="form-col-6">
                    <?= $form->field($model, 'phone_number')->widget(MaskedInput::class, [
                        'mask' => '+7(999)999-99-99',
                        'options' => [
                            'class' => 'beauty-input',
                            'placeholder' => '+7(999)999-99-99',
                        ],
                    ]) ?>
                </div>
                <div class="form-col-6">
                    <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Придумайте пароль']) ?>
                </div>
            </div>

            <div class="form-footer">
                <?= Html::submitButton('✨ Создать аккаунт', ['class' => 'beauty-submit-btn']) ?>
            </div>

            <div class="login-link">
                Уже есть аккаунт? <?= Html::a('Войти', ['/site/login']) ?>
            </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>

<?php
$js = <<< JS
    // Добавляем обработчик для радио-кнопок
    $('.role-btn').on('click', function() {
        // Убираем активный класс у всех
        $('.role-btn').removeClass('active').css('background', '').css('border-color', '');
        
        // Добавляем активный класс текущему
        $(this).addClass('active');
        
        // Устанавливаем соответствующий цвет фона
        var value = $(this).find('input').val();
        if (value == '0') {
            $(this).css({
                'background': '#4361ee',
                'border-color': '#4361ee'
            });
        } else {
            $(this).css({
                'background': '#b3456b',
                'border-color': '#b3456b'
            });
        }
        
        // Устанавливаем радио-кнопку как выбранную
        $(this).find('input').prop('checked', true);
    });
    
    // При загрузке страницы проверяем, есть ли уже выбранная роль
    $(document).ready(function() {
        $('.role-btn input:checked').each(function() {
            var btn = $(this).closest('.role-btn');
            var value = $(this).val();
            btn.addClass('active');
            if (value == '0') {
                btn.css({
                    'background': '#4361ee',
                    'border-color': '#4361ee'
                });
            } else {
                btn.css({
                    'background': '#b3456b',
                    'border-color': '#b3456b'
                });
            }
        });
    });
JS;

$this->registerJs($js);

$css = <<< CSS
    .beauty-registration {
        min-height: 100vh;
        background: linear-gradient(135deg, #fdf2f8 0%, #f8e1e8 100%);
        padding: 40px 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Roboto, 'Helvetica Neue', sans-serif;
    }

    .registration-container {
        max-width: 800px;
        width: 100%;
        background: white;
        border-radius: 30px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1), 0 8px 16px rgba(198, 112, 148, 0.2);
        padding: 40px;
        position: relative;
        overflow: hidden;
    }

    .registration-container::before {
        content: '';
        position: absolute;
        top: -50px;
        right: -50px;
        width: 200px;
        height: 200px;
        background: radial-gradient(circle, #ffd1dc 0%, transparent 70%);
        border-radius: 50%;
        z-index: 0;
    }

    .registration-container::after {
        content: '';
        position: absolute;
        bottom: -50px;
        left: -50px;
        width: 250px;
        height: 250px;
        background: radial-gradient(circle, #ffe4ed 0%, transparent 70%);
        border-radius: 50%;
        z-index: 0;
    }

    .registration-header {
        text-align: center;
        margin-bottom: 30px;
        position: relative;
        z-index: 1;
    }

    .registration-header h1 {
        color: #b3456b;
        font-size: 2.2em;
        font-weight: 600;
        margin: 0 0 10px 0;
        text-shadow: 2px 2px 4px rgba(179, 69, 107, 0.1);
    }

    .subtitle {
        color: #a65a72;
        font-size: 1.1em;
        margin: 0;
    }

    .beauty-form {
        position: relative;
        z-index: 1;
    }

    .role-selection {
        margin-bottom: 30px;
        text-align: center;
    }

    .role-buttons {
        display: flex;
        gap: 20px;
        justify-content: center;
        margin-top: 15px;
    }

    .role-btn {
        flex: 1;
        max-width: 200px;
        padding: 20px;
        background: #f8eef2;
        border: 2px solid #e8cfd9;
        border-radius: 20px;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 10px;
    }

    .role-btn.active {
        transform: translateY(-3px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
    }

    .role-btn.active .role-icon,
    .role-btn.active .role-text {
        color: white;
        font-weight: 600;
    }

    .role-icon {
        font-size: 32px;
        color: #b3456b;
        transition: all 0.3s ease;
    }

    .role-text {
        font-size: 16px;
        font-weight: 500;
        color: #7a4b5f;
        transition: all 0.3s ease;
    }

    .role-btn.active .role-text {
        color: white;
        text-shadow: 0 1px 2px rgba(0,0,0,0.2);
    }

    .role-radio-group {
        display: flex;
        gap: 20px;
        justify-content: center;
        width: 100%;
    }

    .role-radio-group input[type="radio"] {
        display: none;
    }

    .form-row {
        display: flex;
        gap: 20px;
        margin-bottom: 20px;
    }

    .form-col-4 {
        flex: 1;
    }

    .form-col-6 {
        flex: 1;
    }

    .beauty-label {
        display: block;
        margin-bottom: 8px;
        color: #7a4b5f;
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .input-wrapper {
        position: relative;
    }

    .beauty-input {
        width: 100%;
        padding: 14px 18px;
        border: 2px solid #f0d9e3;
        border-radius: 15px;
        font-size: 15px;
        transition: all 0.3s ease;
        background: white;
        color: #4a4a4a;
    }

    .beauty-input:focus {
        outline: none;
        border-color: #b3456b;
        box-shadow: 0 0 0 4px rgba(179, 69, 107, 0.1);
    }

    .beauty-input::placeholder {
        color: #c9a5b6;
        font-style: italic;
    }

    .beauty-error {
        color: #e74c3c;
        font-size: 13px;
        margin-top: 5px;
        padding-left: 15px;
        position: relative;
    }

    .beauty-error::before {
        content: '⚠️';
        position: absolute;
        left: -5px;
        top: 0;
        font-size: 12px;
    }

    .form-footer {
        text-align: center;
        margin: 35px 0 20px;
    }

    .beauty-submit-btn {
        background: linear-gradient(135deg, #b3456b, #d46b91);
        color: white;
        border: none;
        padding: 16px 40px;
        font-size: 1.2em;
        font-weight: 600;
        border-radius: 50px;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 8px 16px rgba(179, 69, 107, 0.3);
        letter-spacing: 1px;
        position: relative;
        overflow: hidden;
    }

    .beauty-submit-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(179, 69, 107, 0.4);
    }

    .beauty-submit-btn:active {
        transform: translateY(0);
    }

    .beauty-submit-btn::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
        transition: left 0.5s ease;
    }

    .beauty-submit-btn:hover::before {
        left: 100%;
    }

    .login-link {
        text-align: center;
        margin-top: 20px;
        color: #a65a72;
        font-size: 0.95em;
    }

    .login-link a {
        color: #b3456b;
        text-decoration: none;
        font-weight: 600;
        border-bottom: 2px solid transparent;
        transition: border-color 0.3s ease;
    }

    .login-link a:hover {
        border-bottom-color: #b3456b;
    }

    @media (max-width: 768px) {
        .registration-container {
            padding: 30px 20px;
        }

        .form-row {
            flex-direction: column;
            gap: 0;
        }

        .role-buttons {
            flex-direction: column;
            align-items: center;
        }

        .role-btn {
            max-width: 100%;
            width: 100%;
        }
    }

    /* Анимации для полей */
    .beauty-input {
        animation: fadeInUp 0.5s ease forwards;
        opacity: 0;
    }

    .form-row:nth-child(1) .beauty-input { animation-delay: 0.1s; }
    .form-row:nth-child(2) .beauty-input { animation-delay: 0.2s; }
    .form-row:nth-child(3) .beauty-input { animation-delay: 0.3s; }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
CSS;

$this->registerCss($css);
?>